/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import cofh.lib.util.helpers.EntityHelper;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.DimensionManager;

public class CommandTPX
implements ISubCommand {
    public static CommandTPX instance = new CommandTPX();

    @Override
    public String getCommandName() {
        return "tpx";
    }

    @Override
    public int getPermissionLevel() {
        return 2;
    }

    @Override
    public void handleCommand(ICommandSender iCommandSender, String[] stringArray) {
        switch (stringArray.length) {
            case 0: 
            case 1: {
                iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
                throw new WrongUsageException("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
            }
            case 2: {
                EntityPlayerMP entityPlayerMP = CommandBase.getCommandSenderAsPlayer((ICommandSender)iCommandSender);
                try {
                    EntityPlayerMP entityPlayerMP2 = CommandBase.getPlayer((ICommandSender)iCommandSender, (String)stringArray[1]);
                    if (!entityPlayerMP2.equals((Object)entityPlayerMP)) {
                        entityPlayerMP2.mountEntity((Entity)null);
                        if (entityPlayerMP.dimension == entityPlayerMP2.dimension) {
                            entityPlayerMP2.setPositionAndUpdate(entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                            CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.tpx.otherToSelf", entityPlayerMP2.getCommandSenderName(), entityPlayerMP2.posX, entityPlayerMP2.posY, entityPlayerMP2.posZ);
                            break;
                        }
                        EntityHelper.transferPlayerToDimension(entityPlayerMP2, entityPlayerMP.dimension, entityPlayerMP.mcServer.getConfigurationManager());
                        entityPlayerMP2.setPositionAndUpdate(entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                        CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.tpx.dimensionOtherToSelf", entityPlayerMP2.getCommandSenderName(), entityPlayerMP2.worldObj.provider.getDimensionName(), entityPlayerMP2.posX, entityPlayerMP2.posY, entityPlayerMP2.posZ);
                        break;
                    }
                    iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.tpx.snark.0", new Object[0]));
                }
                catch (PlayerNotFoundException playerNotFoundException) {
                    int n = 0;
                    try {
                        n = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[1]);
                    }
                    catch (CommandException commandException) {
                        iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
                        iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]));
                        throw playerNotFoundException;
                    }
                    if (!DimensionManager.isDimensionRegistered((int)n)) {
                        throw new CommandException("info.cofh.command.world.notFound", new Object[0]);
                    }
                    entityPlayerMP.mountEntity((Entity)null);
                    if (entityPlayerMP.dimension != n) {
                        EntityHelper.transferPlayerToDimension(entityPlayerMP, n, entityPlayerMP.mcServer.getConfigurationManager());
                    }
                    entityPlayerMP.setPositionAndUpdate(entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                    CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.tpx.dimensionSelf", entityPlayerMP.worldObj.provider.getDimensionName(), entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                }
                break;
            }
            case 3: {
                EntityPlayerMP entityPlayerMP = CommandBase.getPlayer((ICommandSender)iCommandSender, (String)stringArray[1]);
                try {
                    EntityPlayerMP entityPlayerMP3 = CommandBase.getPlayer((ICommandSender)iCommandSender, (String)stringArray[2]);
                    if (!entityPlayerMP.equals((Object)entityPlayerMP3)) {
                        entityPlayerMP.mountEntity((Entity)null);
                        if (entityPlayerMP3.dimension == entityPlayerMP.dimension) {
                            entityPlayerMP.setPositionAndUpdate(entityPlayerMP3.posX, entityPlayerMP3.posY, entityPlayerMP3.posZ);
                            CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.tpx.otherTo", entityPlayerMP.getCommandSenderName(), entityPlayerMP3.getCommandSenderName(), entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                            break;
                        }
                        EntityHelper.transferPlayerToDimension(entityPlayerMP, entityPlayerMP3.dimension, entityPlayerMP3.mcServer.getConfigurationManager());
                        entityPlayerMP.setPositionAndUpdate(entityPlayerMP3.posX, entityPlayerMP3.posY, entityPlayerMP3.posZ);
                        CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.tpx.dimensionOtherTo", entityPlayerMP.getCommandSenderName(), entityPlayerMP3.getCommandSenderName(), entityPlayerMP.worldObj.provider.getDimensionName(), entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                        break;
                    }
                    iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.tpx.snark.1", new Object[]{stringArray[1]}));
                }
                catch (PlayerNotFoundException playerNotFoundException) {
                    int n = 0;
                    try {
                        n = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[2]);
                    }
                    catch (CommandException commandException) {
                        iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
                        iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]));
                        throw playerNotFoundException;
                    }
                    if (!DimensionManager.isDimensionRegistered((int)n)) {
                        throw new CommandException("info.cofh.command.world.notFound", new Object[0]);
                    }
                    entityPlayerMP.mountEntity((Entity)null);
                    if (entityPlayerMP.dimension != n) {
                        EntityHelper.transferPlayerToDimension(entityPlayerMP, n, entityPlayerMP.mcServer.getConfigurationManager());
                    }
                    entityPlayerMP.setPositionAndUpdate(entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                    CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.tpx.dimensionOther", entityPlayerMP.getCommandSenderName(), entityPlayerMP.worldObj.provider.getDimensionName(), entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                }
                break;
            }
            case 4: {
                EntityPlayerMP entityPlayerMP = CommandBase.getCommandSenderAsPlayer((ICommandSender)iCommandSender);
                entityPlayerMP.setPositionAndUpdate(CommandBase.func_110666_a((ICommandSender)entityPlayerMP, (double)entityPlayerMP.posX, (String)stringArray[1]), CommandBase.func_110666_a((ICommandSender)entityPlayerMP, (double)entityPlayerMP.posY, (String)stringArray[2]), CommandBase.func_110666_a((ICommandSender)entityPlayerMP, (double)entityPlayerMP.posZ, (String)stringArray[3]));
                CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.tpx.self", entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                break;
            }
            case 5: {
                try {
                    EntityPlayerMP entityPlayerMP = CommandBase.getPlayer((ICommandSender)iCommandSender, (String)stringArray[1]);
                    entityPlayerMP.mountEntity((Entity)null);
                    entityPlayerMP.setPositionAndUpdate(CommandBase.func_110666_a((ICommandSender)entityPlayerMP, (double)entityPlayerMP.posX, (String)stringArray[2]), CommandBase.func_110666_a((ICommandSender)entityPlayerMP, (double)entityPlayerMP.posY, (String)stringArray[3]), CommandBase.func_110666_a((ICommandSender)entityPlayerMP, (double)entityPlayerMP.posZ, (String)stringArray[4]));
                    CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.tpx.other", entityPlayerMP.getCommandSenderName(), entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                }
                catch (PlayerNotFoundException playerNotFoundException) {
                    int n;
                    try {
                        n = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[4]);
                    }
                    catch (CommandException commandException) {
                        iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
                        iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]));
                        throw playerNotFoundException;
                    }
                    EntityPlayerMP entityPlayerMP = CommandBase.getCommandSenderAsPlayer((ICommandSender)iCommandSender);
                    if (!DimensionManager.isDimensionRegistered((int)n)) {
                        throw new CommandException("info.cofh.command.world.notFound", new Object[0]);
                    }
                    entityPlayerMP.mountEntity((Entity)null);
                    if (entityPlayerMP.dimension != n) {
                        EntityHelper.transferPlayerToDimension(entityPlayerMP, n, entityPlayerMP.mcServer.getConfigurationManager());
                    }
                    entityPlayerMP.setPositionAndUpdate(entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                    CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.tpx.dimensionSelf", entityPlayerMP.worldObj.provider.getDimensionName(), entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
                }
                break;
            }
            default: {
                EntityPlayerMP entityPlayerMP = CommandBase.getPlayer((ICommandSender)iCommandSender, (String)stringArray[1]);
                int n = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[5]);
                if (!DimensionManager.isDimensionRegistered((int)n)) {
                    throw new CommandException("info.cofh.command.world.notFound", new Object[0]);
                }
                entityPlayerMP.mountEntity((Entity)null);
                if (entityPlayerMP.dimension != n) {
                    EntityHelper.transferPlayerToDimension(entityPlayerMP, n, entityPlayerMP.mcServer.getConfigurationManager());
                }
                entityPlayerMP.setPositionAndUpdate(CommandBase.func_110666_a((ICommandSender)entityPlayerMP, (double)entityPlayerMP.posX, (String)stringArray[2]), CommandBase.func_110666_a((ICommandSender)entityPlayerMP, (double)entityPlayerMP.posY, (String)stringArray[3]), CommandBase.func_110666_a((ICommandSender)entityPlayerMP, (double)entityPlayerMP.posZ, (String)stringArray[4]));
                CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.tpx.dimensionOther", entityPlayerMP.getCommandSenderName(), entityPlayerMP.worldObj.provider.getDimensionName(), entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ);
            }
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 2 || stringArray.length == 3) {
            return CommandBase.getListOfStringsMatchingLastWord((String[])stringArray, (String[])MinecraftServer.getServer().getAllUsernames());
        }
        if (stringArray.length >= 6) {
            Integer[] integerArray = DimensionManager.getIDs();
            String[] stringArray2 = new String[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                stringArray2[i] = integerArray[i].toString();
            }
            return CommandBase.getListOfStringsMatchingLastWord((String[])stringArray, (String[])stringArray2);
        }
        return null;
    }
}

